/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.GrapplemodReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GrapplemodHandler {
    private GrapplemodReflect reflector;

    public GrapplemodHandler() {
        block2: {
            try {
                this.reflector = new GrapplemodReflect();
                CompatUtil.wrapSpecificHandler("GMLivingFallEvent", x$0 -> new GMLivingFallEvent((IEventListener)x$0), "com.yyon.grapplinghook.CommonProxyClass", "onLivingFallEvent");
                CompatUtil.wrapSpecificHandler("GMLivingFallEvent", x$0 -> new GMLivingFallEvent((IEventListener)x$0), "com.yyon.grapplinghook.ServerProxyClass", "onLivingFallEvent");
                CompatUtil.wrapSpecificHandler("GMLivingFallEvent", x$0 -> new GMLivingFallEvent((IEventListener)x$0), "com.yyon.grapplinghook.ClientProxyClass", "onLivingFallEvent");
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup GrapplemodHandler!", (Throwable)e);
                ErrorUtil.logSilent("GrapplemodHandler Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!ModConfig.server.grapplemod.hinderGrapplingWhileFalling) {
            return;
        }
        if (this.reflector.c_grappleArrow.isInstance(event.getEntity()) && event.getEntity() instanceof EntityThrowable) {
            EntityThrowable throwable = (EntityThrowable)event.getEntity();
            if (throwable.field_70181_x >= 0.0) {
                return;
            }
            Entity shooting = null;
            try {
                shooting = (Entity)this.reflector.f_grappleArrow_shootingEntity.get(this.reflector.c_grappleArrow.cast(throwable));
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("GrapplemodHandler shootingEntity Failure");
                return;
            }
            if (shooting == null) {
                return;
            }
            if (shooting.field_70181_x >= (double)-0.1f) {
                return;
            }
            throwable.field_70181_x = Math.min(shooting.field_70181_x + 0.5, 0.0);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && ModConfig.server.grapplemod.grapplingHookFallDamage && event.player != null && !event.player.field_70170_p.field_72995_K && this.reflector.getIsAttached(event.player.func_145782_y()) && event.player.field_70143_R > 3.0f && !event.player.field_70122_E && event.player.field_70181_x >= -0.6) {
            event.player.field_70143_R = 0.0f;
        }
    }

    public class GMLivingFallEvent {
        private IEventListener handler;

        public GMLivingFallEvent(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onLivingFallEvent(LivingFallEvent event) {
            this.handler.invoke((Event)event);
            if (event.isCanceled() && ModConfig.server.grapplemod.grapplingHookFallDamage) {
                event.setCanceled(false);
            }
        }
    }
}

